<div class="form-group row">
    <label  class="col-xl-3 col-md-4" for="{{ $id }}">{{ $labelTitle }}</label>
    <div class="col-xl-8 col-md-7">
        <select class="custom-select select2 w-100 form-control"
                id="{{ $id }}"
                name="{{ $name }}"
                @isset($multible) multiple @endisset
                @isset($required) required @endisset>
            <option value="" disabled @if(!isset($multible)) selected @endif>--Select Option--</option>
            @foreach($options as $key => $option)
                @php
                    $isObject = is_object($option);
                    // Check if this is an associative array (key-value pairs where key is ID)
                    $isAssociativeArray = !$isObject && is_numeric($key) && is_string($option);
                    
                    if ($isAssociativeArray) {
                        // For associative arrays like [id => title], use key as value and option as text
                        $optionValue = $key;
                        $optionText = $option;
                    } else {
                        // For objects or indexed arrays
                        $optionValue = isset($trackBy) 
                            ? ($isObject ? $option->{$trackBy} : $option[$trackBy]) 
                            : ($isObject ? $option->id ?? $option : $option);
                        $optionText = isset($optionLabel) 
                            ? ($isObject ? $option->{$optionLabel} : $option[$optionLabel])
                            : (isset($optionLable) 
                                ? ($isObject ? $option->{$optionLable} : $option[$optionLable])
                                : ($isObject ? $option->title ?? $option->name ?? (string)$option : $option));
                    }
                @endphp
                <option
                    @isset($value)
                        @if(isset($multible) ?
                            in_array($optionValue, is_array($value) ? $value : [$value]) :
                             $value == $optionValue)
                            selected
                    @endif

                    @endisset
                    value="{{ $optionValue }}">
                    {{ Str::headline($optionText) }}
                </option>
            @endforeach
        </select>
        @isset($errorKey)
            @error($errorKey)
            <span class="d-block text-danger">{{ $message }}</span>
            @enderror
        @endisset
    </div>
</div>
