@extends('layouts.dashboard.app')

@section('content')
    <form action="{{ route('dashboard.rooms.store' ) }}" method="POST" class="page-body">
        @csrf

        <!-- Container-fluid starts-->
        <x-dashboard.partials.breadcrumb title="Create Room" :hideFirst="true">
            <li class="breadcrumb-item">
                <a href="{{ route('dashboard.rooms.index') }}">Rooms</a>
            </li>
        </x-dashboard.partials.breadcrumb>
        <!-- Container-fluid Ends-->

        <!-- Container-fluid starts-->
        <div class="container-fluid">
            <div class="row">
                <x-dashboard.partials.message-alert/>

                <div class="card tab2-card">
                    <div class="card-body needs-validation">
                        <x-dashboard.form.language-multi-tab-card tab-id="hotels">
                            @foreach(config('translatable.supported_locales') as $localKey => $local)
                                <div @class(['tab-pane fade', 'active show' => $localKey == config('app.locale')])
                                     id="{{ 'hotels-'.$localKey }}" role="tabpanel"
                                     aria-labelledby="{{ 'hotels-'.$localKey }}-tab">
                                    <x-dashboard.form.input-text error-key="{{$localKey}}.name"
                                                                 name="{{$localKey}}[name]" id="{{$localKey}}-name"
                                                                 label-title="Name"/>

                                    <x-dashboard.form.input-editor error-key="{{$localKey}}.description"
                                                                   name="{{$localKey}}[description]"
                                                                   id="{{$localKey}}-description"
                                                                   label-title="Description"/>


                                </div>
                            @endforeach
                        </x-dashboard.form.language-multi-tab-card>
                        <x-dashboard.form.submit-button/>
                    </div>
                </div>

                <div class="card tab2-card">
                    <div class="card-body">
                        <x-dashboard.form.multi-tab-card
                            :tabs="['featured', 'media']"
                            tab-id="featured-media">
                            <div class="tab-pane fade active show"
                                 id="{{ 'featured-media-0' }}" role="tabpanel"
                                 aria-labelledby="{{ 'featured-media-0' }}-tab">

                                <x-dashboard.form.input-text error-key="slug" name="slug" id="slug" label-title="Slug"/>

                                <x-dashboard.form.input-select
                                    name="hotel_id"
                                    :options="$hotels"
                                    :value="old('hotel_id', request('hotel_id'))"
                                    track-by="id"
                                    option-lable="name"
                                    label-title="Hotel"
                                    id="hotel_id"
                                    error-key="hotel_id"/>

                                <x-dashboard.form.input-select
                                    name="amenities[]"
                                    multible
                                    :options="$amenities"
                                    track-by="id"
                                    option-lable="name"
                                    label-title="Amenities"
                                    id="amenities"
                                    error-key="amenities"/>

                                <x-dashboard.form.input-checkbox resource-name="Room"
                                                                 :value="true"
                                                                 error-key="enabled"
                                                                 name="enabled" id="enabled"
                                                                 label-title="Enabled"/>

                                <x-dashboard.form.input-text error-key="bed_count" name="bed_count" id="bed_count"
                                                             label-title="Bed Count"/>

                                <x-dashboard.form.input-text error-key="room_type" name="room_type" id="room_type"
                                                             label-title="Room Type"/>

                                <x-dashboard.form.input-text error-key="max_capacity" name="max_capacity" id="max_capacity"
                                                             label-title="Max Capacity"/>

                                <x-dashboard.form.input-text error-key="bed_types" name="bed_types" id="bed_types"
                                                             label-title="Bed Types"/>

                                <x-dashboard.form.input-text error-key="night_price" name="night_price" id="night_price"
                                                             label-title="Night Price"/>

                                <!-- Extra Bed Section -->
                                <div class="row">
                                    <div class="col-12">
                                        <h6 class="mb-3">Extra Bed Configuration</h6>
                                    </div>
                                </div>

                                <x-dashboard.form.input-checkbox resource-name="Extra Bed"
                                                                 :value="false"
                                                                 error-key="extra_bed_available"
                                                                 name="extra_bed_available" id="extra_bed_available"
                                                                 label-title="Extra Bed Available"/>

                                <x-dashboard.form.input-text error-key="extra_bed_price" name="extra_bed_price" id="extra_bed_price"
                                                             label-title="Extra Bed Price (per night)"
                                                             type="number"
                                                             step="0.01"
                                                             min="0"/>

                                <x-dashboard.form.input-text error-key="max_extra_beds" name="max_extra_beds" id="max_extra_beds"
                                                             label-title="Maximum Extra Beds"
                                                             type="number"
                                                             min="0"
                                                             max="5"
                                                             value="1"/>

                                <x-dashboard.form.input-textarea error-key="extra_bed_description" name="extra_bed_description" id="extra_bed_description"
                                                                 label-title="Extra Bed Description"
                                                                 placeholder="Describe the extra bed service..."/>

                            </div>
                            <div class="tab-pane fade"
                                 id="{{ 'featured-media-1' }}" role="tabpanel"
                                 aria-labelledby="{{ 'featured-media-1' }}-tab">
                                <x-dashboard.form.media title="Add Banner Image"
                                                        :images="old('banner')"
                                                        name="banner"/>

                                <x-dashboard.form.media title="Add Featured Image"
                                                        :images="old('featured_image')"
                                                        name="featured_image"/>

                                <x-dashboard.form.media title="Add Gallery" :multiple="true"
                                                        :images="old('gallery')"
                                                        name="gallery[]"/>
                            </div>
                        </x-dashboard.form.multi-tab-card>

                        <x-dashboard.form.submit-button/>
                    </div>
                </div>


                <!--Start SEO-->
                <x-dashboard.form.seo-form/>
                <!--End SEO-->

            </div>
        </div>
        <!-- Container-fluid Ends-->

    </form>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const extraBedCheckbox = document.getElementById('extra_bed_available');
    const extraBedPrice = document.getElementById('extra_bed_price');
    const maxExtraBeds = document.getElementById('max_extra_beds');
    const extraBedDescription = document.getElementById('extra_bed_description');

    function toggleExtraBedFields() {
        const isEnabled = extraBedCheckbox.checked;
        extraBedPrice.disabled = !isEnabled;
        maxExtraBeds.disabled = !isEnabled;
        extraBedDescription.disabled = !isEnabled;
        
        if (!isEnabled) {
            extraBedPrice.value = '';
            maxExtraBeds.value = '1';
            extraBedDescription.value = '';
        }
    }

    extraBedCheckbox.addEventListener('change', toggleExtraBedFields);
    toggleExtraBedFields(); // Initial state
});
</script>
@endsection
