@extends('layouts.dashboard.app')

@section('content')
    <div class="page-body">
        <!-- Container-fluid starts-->
        <x-dashboard.partials.breadcrumb title="Tours">
            <li class="breadcrumb-item active">Tours</li>
        </x-dashboard.partials.breadcrumb>
        <!-- Container-fluid Ends-->

        <!-- Container-fluid starts-->
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <x-dashboard.partials.message-alert />
                    <div class="card">
                        <x-dashboard.partials.table-card-header model="tour">
                            <div class="d-flex gap-2">
                                <a href="{{ route('dashboard.tours.export') }}" type="button" class="btn btn-success add-row mt-md-0 mt-2">
                                    <i class="fa icon fa-download"></i> Export All Tours
                                </a>
                                <button type="button" class="btn btn-info add-row mt-md-0 mt-2" data-bs-toggle="modal" data-bs-target="#importModal">
                                    <i class="fa icon fa-upload"></i> Import Tours
                                </button>
                                <a data-model="Destination" href="#" type="button" class="auto-translate btn btn-primary add-row mt-md-0 mt-2">
                                    <i class="fa icon fa-language"></i> Auto Translate
                                </a>
                            </div>
                        </x-dashboard.partials.table-card-header>
                        <div class="card-body order-datatable overflow-x-auto">
                            <div class="">
                                {!! $dataTable->table(['class'=>'display']) !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Container-fluid Ends-->
    </div>

    <!-- Import Modal -->
    <div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="importModalLabel">Import Tours</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('dashboard.tours.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="importFile" class="form-label">Select JSON File</label>
                            <input type="file" class="form-control" id="importFile" name="file" accept=".json" required>
                            <small class="form-text text-muted">Please select a JSON file exported from this system.</small>
                        </div>
                        <div class="alert alert-info">
                            <strong>Note:</strong> Tours with the same slug or code will be updated. New tours will be created.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Import</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
