<?php

use App\Http\Controllers\Dashboard\AutoTranslationController;
use App\Http\Controllers\Dashboard\BlogController;
use App\Http\Controllers\Dashboard\BookingController;
use App\Http\Controllers\Dashboard\CarRentalController;
use App\Http\Controllers\Dashboard\CarRouteController;
use App\Http\Controllers\Dashboard\CategoryController;
use App\Http\Controllers\Dashboard\ClientController;
use App\Http\Controllers\Dashboard\ContactRequestController;
use App\Http\Controllers\Dashboard\CouponController;
use App\Http\Controllers\Dashboard\CurrencyController;
use App\Http\Controllers\Dashboard\CustomTripController;
use App\Http\Controllers\Dashboard\DestinationController;
use App\Http\Controllers\Dashboard\LocationController;
use App\Http\Controllers\Dashboard\MainController;
use App\Http\Controllers\Dashboard\PageController;
use App\Http\Controllers\Dashboard\RoleController;
use App\Http\Controllers\Dashboard\SettingController;
use App\Http\Controllers\Dashboard\SitemapController;
use App\Http\Controllers\Dashboard\TourController;
use App\Http\Controllers\Dashboard\TourOptionController;
use App\Http\Controllers\Dashboard\TourReviewController;
use App\Http\Controllers\Dashboard\TripController;
use App\Http\Controllers\Dashboard\TripBookingController;
use App\Http\Controllers\Dashboard\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Dashboard\FaqController;
use App\Http\Controllers\Dashboard\BlogCategoryController;
use App\Http\Controllers\Dashboard\CustomizedTripCategoryController;
use App\Http\Controllers\Dashboard\RedirectRuleController;
use App\Http\Controllers\Dashboard\AmenityController;
use App\Http\Controllers\Dashboard\HotelController;
use App\Http\Controllers\Dashboard\RoomController;
use App\Http\Controllers\Dashboard\HotelRoomBookingController;
use Illuminate\Support\Facades\Route;
//controllers
Route::group([
    'prefix' => 'dashboard',
    'middleware' => ['auth:web', 'permitted'],
    'as' => 'dashboard.'
], function () {
    
    // Profile & Theme Routes
    Route::get('toggle-theme', [ProfileController::class, 'toggleTheme'])->name('toggle-theme');
    
    // System Routes
    Route::post('cache/clear', [MainController::class, 'clearCache'])->name('cache.clear');
    Route::post('translate', [AutoTranslationController::class, 'translate'])->name('model.auto.translate');
    Route::get('sitemap/generate', SitemapController::class)->name('sitemap.generate');
    
    // User Management
    Route::resource('users', UserController::class)->except('show');
    Route::resource('roles', RoleController::class)->except('show');
    Route::resource('clients', ClientController::class)->except('show');
    
    // Content Management
    Route::resource('destinations', DestinationController::class)->except('show');
    Route::resource('categories', CategoryController::class)->except('show');
    Route::resource('tours', TourController::class)->except('show');
    Route::get('tours/export', [TourController::class, 'export'])->name('tours.export');
    Route::post('tours/import', [TourController::class, 'import'])->name('tours.import');
 
    Route::resource('tour-options', TourOptionController::class)->except('show');
    Route::resource('pages', PageController::class)->except('show');
    Route::resource('blogs', BlogController::class)->except('show');
    Route::resource('blog-categories', BlogCategoryController::class)->except('show');
    Route::resource('locations', LocationController::class)->except('show');
    Route::resource('faqs', FaqController::class)->except('show');
    
    // Hotel Management
    Route::resource('hotels', HotelController::class)->except('show');
    Route::resource('rooms', RoomController::class)->except('show');
    Route::resource('amenities', AmenityController::class)->except('show');
    Route::resource('hotel_room_bookings', HotelRoomBookingController::class);
    
    // Car Rental Management
    Route::resource('car-routes', CarRouteController::class)->except('show');
    Route::post('car-routes/import', [CarRouteController::class, 'import'])->name('car-routes.import');
    Route::get('car-routes/template', [CarRouteController::class, 'template'])->name('car-routes.template');
    
    Route::group(['prefix' => 'car-rentals', 'as' => 'car-rentals.'], function () {
        Route::get('/', [CarRentalController::class, 'index'])->name('index');
        Route::get('/{carRental}', [CarRentalController::class, 'show'])->name('show');
    });
    
    // Custom Trips Management
    Route::group(['prefix' => 'custom-trips', 'as' => 'custom-trips.'], function () {
        Route::get('/', [CustomTripController::class, 'index'])->name('index');
        Route::get('/{customTrip}', [CustomTripController::class, 'show'])->name('show');
        Route::put('/{customTrip}', [CustomTripController::class, 'assign'])->name('assign');
    });
    
    Route::resource('customized-trip-categories', CustomizedTripCategoryController::class)->except('show');
    
    // Trips & Bookings Management
    Route::resource('trips', TripController::class);
    Route::get('trips/{trip}/bookings', [TripController::class, 'tripBookings'])->name('trips.trip-bookings');
    Route::post('trips/{trip}/toggle-status', [TripController::class, 'toggleStatus'])->name('trips.toggle-status');
    Route::get('trips/{trip}/details', [TripController::class, 'getTripDetails'])->name('trips.details');
    
    Route::resource('trip-bookings', TripBookingController::class);
    Route::post('trip-bookings/{tripBooking}/toggle-status', [TripBookingController::class, 'toggleStatus'])->name('trip-bookings.toggle-status');
    Route::post('trip-bookings/{tripBooking}/cancel', [TripBookingController::class, 'cancel'])->name('trip-bookings.cancel');
    Route::get('trip-bookings/export', [TripBookingController::class, 'export'])->name('trip-bookings.export');
    
    // Financial Management
    Route::resource('coupons', CouponController::class)->except('show');
    Route::resource('currencies', CurrencyController::class)->except('show');
    Route::get('currencies/rates/update', [CurrencyController::class, 'updateRates'])->name('currencies.rates.update');
    
    // Booking Management
    Route::resource('bookings', BookingController::class)->except(['create', 'store', 'edit', 'destroy']);
    Route::resource('tour-reviews', TourReviewController::class)->only('index');
    
    // Contact Management
    Route::resource('contact-requests', ContactRequestController::class)->except('show');
    Route::post('contact-requests/mark-as-spam', [ContactRequestController::class, 'markAsSpam'])
        ->name('contact-requests.mark-as-spam');
    
    // SEO & Redirects
    Route::resource('redirect-rules', RedirectRuleController::class)->except('show');
    Route::get('redirect-rules/export', [RedirectRuleController::class, 'export'])->name('redirect-rules.export');
    Route::post('redirect-rules/import', [RedirectRuleController::class, 'import'])->name('redirect-rules.import');
    
    // Settings
    Route::group(['prefix' => 'settings', 'as' => 'settings.'], function () {
        Route::get('show', [SettingController::class, 'show'])->name('show');
        Route::put('update', [SettingController::class, 'update'])->name('update');
    });
    //RoutePlace
});
