<?php

use App\Events\NewBookingEvent;
use App\Http\Controllers\Api\HotelController;
use App\Http\Controllers\Dashboard\HotelRoomBookingController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
require __DIR__.'/auth.php';
require __DIR__.'/admin.php';

Route::redirect('/', '/login');

Route::get('/dashboard', function () {
    return view('dashboard.home.index');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::get('dashboard/hotels/{hotel}/rooms', [HotelRoomBookingController::class, 'getRoomsByHotel'])
    ->name('dashboard.hotels.rooms');

Route::get('/test',function () {
//    $booking= \App\Models\Booking::find(53);
//    event(new NewBookingEvent($booking));
//    $start = now();
//    $blog = \App\Models\Blog::find(7);
//    $data = \App\Services\Translation\Translator::translate($blog->description, 'fr');
//    $blog->update([
//        'fr' => [
//            'description' => $data
//        ]
//    ]);
//    dd($data, now()->diffForHumans($start));
//    $c = \App\Models\CustomTrip::find(5);
//    event(new \App\Events\NewCustomTripRequestEvent($c));

//    $booking = \App\Models\Booking::latest()->first();
//    dd($booking->meta);
//    event(new \App\Events\NewBookingEvent($booking));
//    dd('SENT!');
//    $social_links = \App\Models\Setting::whereOptionKey('social_links')->first()?->option_value;
//    return view('emails.client.new-booking', compact('booking','social_links'));
});

// Diagnostic route to check Vite configuration
Route::get('/vite-debug', function () {
    $manifestPath = public_path('build/manifest.json');
    $manifestExists = file_exists($manifestPath);
    $manifestContent = $manifestExists ? json_decode(file_get_contents($manifestPath), true) : null;
    
    $hotFilePath = public_path('hot');
    $hotFileExists = file_exists($hotFilePath);
    $hotFileContent = $hotFileExists ? file_get_contents($hotFilePath) : null;
    
    // Check what Vite helper would do
    $vite = app(\Illuminate\Foundation\Vite::class);
    $isRunningHot = $vite->isRunningHot();
    
    return response()->json([
        'app_env' => config('app.env'),
        'app_debug' => config('app.debug'),
        'is_local' => app()->environment('local'),
        'is_production' => app()->environment('production'),
        'manifest_exists' => $manifestExists,
        'manifest_path' => $manifestPath,
        'manifest_content' => $manifestContent,
        'vite_asset_url' => config('app.asset_url'),
        'hot_file_exists' => $hotFileExists,
        'hot_file_path' => $hotFilePath,
        'hot_file_content' => $hotFileContent,
        'vite_is_running_hot' => $isRunningHot,
        'fix_required' => $hotFileExists ? 'DELETE public/hot file in production!' : 'No fix needed',
    ]);
});


